# ^[QbgXe[^XEBhE\郂W[
# Author:: fukuyama
# Date:: 2008/02/19
# Copyright:: Copyright (c) 2008 rgss-lib

module DQ
  module Window_Target_Status_Module
    # 
    def initialize_target_status(x,y,w)
      h = Markup_New_Line.line_height * 2 + 32
      @window_target_status = Window_Markup_Text.new(x,y,w,h)
      @window_target_status.back_opacity = self.back_opacity

      # qEBhEɒǉ
      add_child @window_target_status
      @window_target_status.visible = true

      @prev_target_index = -1

      if refresh_hp?
        @target_status_mode = 'hp'
      elsif refresh_sp?
        @target_status_mode = 'sp'
      elsif refresh_condition?
        @target_status_mode = 'condition'
      else
        @target_status_mode = 'hp'
      end
    end

    # ΏۃXe[^X̍XVil\́j
    def refresh_target_value(n,m,word)
      color = '\C[n]'
      if n == 0
        color = '\C[ko]'
      elsif n < m / 4
        color = '\C[cs]'
      end
      n = sprintf("%4d",n)
      m = sprintf("%4d",m)
      text = ''
      text << "\\C[n]\\left[#{word}]#{word}\\n"
      text << "#{color}\\center_left[#{n} ]#{n}"
      text << "\\C[n]\\center_right[/ #{m}]/ #{m}"
      @window_target_status.set_text(text)
    end

    # ΏۃXe[^X̍XViXe[gj
    def refresh_target_condition()
      word = ''
      state = make_battler_state_text(actor, width, true)
      text = ''
      text << "\\C[n]\\left[#{word}].\\n"
      text << "\\C[n]\\center(#{state})."
      @window_target_status.set_text(text)
    end

    # HPΏۂɂXVH
    def refresh_hp?
      window = get_window(Window_Item)
      window = get_window(::DQ::Battle::Window_Item) if window.nil?
      unless window.nil?
        item = Item_Facade.get_use_item(window.item)
        if item.nil?
          return false
        end
        return item.recover_hp_item?
      end
      window = get_window(Window_Skill)
      window = get_window(::DQ::Battle::Window_Skill) if window.nil?
      unless window.nil?
        skill = window.skill
        return (skill.power < 0)
      end
      return false
    end

    # SPΏۂɂXVH
    def refresh_sp?
      window = get_window(Window_Item)
      window = get_window(::DQ::Battle::Window_Item) if window.nil?
      unless window.nil?
        item = Item_Facade.get_use_item(window.item)
        if item.nil?
          return false
        end
        return item.recover_sp_item?
      end
      return false
    end

    # ԕωΏۂɂXVH
    def refresh_condition?
      window = get_window(Window_Item)
      window = get_window(::DQ::Battle::Window_Item) if window.nil?
      unless window.nil?
        item = Item_Facade.get_use_item(window.item)
        if item.nil?
          return false
        end
        return item.state_change_item?
      end
      window = get_window(Window_Skill)
      window = get_window(::DQ::Battle::Window_Skill) if window.nil?
      unless window.nil?
        skill = window.skill
        if skill.nil?
          return false
        end
        return skill.state_change_skill?
      end
      return false
    end

    def refresh_target_status()
      case @target_status_mode
      when 'hp'
        refresh_target_value(actor.hp,actor.maxhp,$data_system.words.hp)
      when 'sp'
        refresh_target_value(actor.sp,actor.maxsp,$data_system.words.sp)
      when 'condition'
        refresh_target_condition()
      end
    end

    def update
      if @index != @prev_target_index and @index >= 0
        refresh_target_status()
        @prev_target_index = @index
      end
      super
    end

  end

end
